//---------------------------------------------------------------------------

#ifndef BackupProcess_FormH
#define BackupProcess_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <TntForms.hpp>
#include "Environment.h"
#include "CGAUGES.h"
#include "TntStdCtrls.hpp"
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
class TBackupProcessForm : public TTntForm
{
__published:	// IDE-managed Components
  TTntLabel *Label1;
  TTntLabel *Label2;
  TTntLabel *Label3;
  TTntLabel *Label4;
  TTntLabel *Label5;
  TTntLabel *CalculateBackupSpaceLabel;
  TTntLabel *BackupUserInfoLabel;
  TTntLabel *BackupSystemInfoLabel;
  TTntLabel *BackupProductInfoLabel;
  TTntLabel *BackupDefectImageLabel;
  TTntButton *BreakButton;
  TTntGroupBox *ProductBackupProgressGroupBox;
  TTntLabel *Label6;
  TTntLabel *Label7;
  TCGauge *CGauge1;
  TTntLabel *ProductNameLabel;
  TTntLabel *TntLabel1;
  TTntLabel *BackupAuditTrailLabel;
  void __fastcall BreakButtonClick(TObject *Sender);
private:	// User declarations
  TBackupContents BackupContents;
  AnsiString BackupDir;
  bool BreakActivate;

  void __fastcall BackupStart(void);
  void __fastcall CalculateBackupSpace(void);
  bool __fastcall BackupUserInfo(void);
  bool __fastcall BackupSystemInfo(void);
  bool __fastcall BackupProductInfo(bool bIncludeProductImage);
  bool __fastcall BackupDefectImage(void);
    bool __fastcall BackupAuditTrail(void);
  void __fastcall CopyDir(AnsiString destDir, AnsiString srcDir);
  void __fastcall CopyDirExcludeImage(AnsiString destDir, AnsiString srcDir);
  void __fastcall CopyOneImage(AnsiString destDir, AnsiString srcDir);
	void __fastcall RemoveWholeDir(AnsiString folderName);

public:		// User declarations
  __fastcall TBackupProcessForm(TComponent* Owner);
  int __fastcall Execute(AnsiString backupDir, TBackupContents backupContents);
};
//---------------------------------------------------------------------------
extern PACKAGE TBackupProcessForm *BackupProcessForm;
//---------------------------------------------------------------------------
#endif
